-- <?php exit;?>

CREATE TABLE `p8_site` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `sitename` varchar(20) NOT NULL default '',
  `alias` varchar(100) NOT NULL default '',
  `ip` varchar(255) NOT NULL default '',
  `point` varchar(10) NOT NULL default '',
  `domain` varchar(255) NOT NULL default '',
  `ipordomain` tinyint(1) NOT NULL default '0',
  `manager` varchar(255) NOT NULL default '',
  `manager_role` varchar(255) NOT NULL default '',
  `poster`  varchar(255) NOT NULL DEFAULT '',
  `display` smallint(5) unsigned NOT NULL default '0',
  `sort` smallint(5) unsigned NOT NULL default '0',
  `template` varchar(100) NOT NULL default '',
  `lock` tinyint(1) NOT NULL default '0',
  `status` tinyint(1) NOT NULL default '0',
  `timestamp` int(10) unsigned NOT NULL default '0',
  `update` int(10) unsigned NOT NULL default '0',
  `config` text NOT NULL default '',
  `data1` text NOT NULL default '',
  `data2` text NOT NULL default '',
  `data3` text NOT NULL default '',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `alias` (`alias`)
)ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE `p8_site_recycle` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `sitename` varchar(20) NOT NULL default '',
  `alias` varchar(100) NOT NULL default '',
  `ip` varchar(255) NOT NULL default '',
  `point` varchar(10) NOT NULL default '',
  `domain` varchar(255) NOT NULL default '',
  `ipordomain` tinyint(1) NOT NULL default '0',
  `manager` varchar(255) NOT NULL default '',
  `manager_role` varchar(255) NOT NULL default '',
  `poster`  varchar(255) NOT NULL DEFAULT '',
  `display` smallint(5) unsigned NOT NULL default '0',
  `sort` smallint(5) unsigned NOT NULL default '0',
  `template` varchar(100) NOT NULL default '',
  `lock` tinyint(1) NOT NULL default '0',
  `status` tinyint(1) NOT NULL default '0',
  `timestamp` int(10) unsigned NOT NULL default '0',
  `update` int(10) unsigned NOT NULL default '0',
  `config` text NOT NULL default '',
  `data1` text NOT NULL default '',
  `data2` text NOT NULL default '',
  `data3` text NOT NULL default '',
  PRIMARY KEY  (`id`)
)ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE `p8_member` (
  `id` mediumint(8) unsigned NOT NULL,
  `username` char(20) NOT NULL default '',
  `role_id` smallint(5) unsigned NOT NULL,
  `item_count` smallint(5) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `username` (`username`),
  KEY `role_id` (`role_id`)
)ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE `p8_model` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` char(30) NOT NULL DEFAULT '',
  `alias` char(30) NOT NULL DEFAULT '',
  `site` varchar(50) NOT NULL DEFAULT '',
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `display_order` tinyint(2) NOT NULL DEFAULT '0',
  `config` text NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
)ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE `p8_item` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `model` varchar(20) NOT NULL default '',
  `title` varchar(100) NOT NULL default '',
  `title_color` varchar(7) NOT NULL default '',
  `title_bold` tinyint(1) NOT NULL default '0',
  `sub_title` varchar(120) NOT NULL DEFAULT '',
  `site` varchar(50) NOT NULL DEFAULT '',
  `cid` mediumint(8) unsigned NOT NULL default '0',
  `frame` varchar(100) NOT NULL default '',
  `url` varchar(100) NOT NULL default '',
  `uid` mediumint(8) unsigned NOT NULL default '0',
  `author` varchar(20) NOT NULL default '',
  `editer` varchar(20) NOT NULL default '',
  `username` varchar(20) NOT NULL default '',
  `attributes` varchar(40) NOT NULL default '',
  `summary` varchar(255) NOT NULL default '',
  `pages` smallint(5) unsigned NOT NULL default '1',
  `html_view_url_rule` varchar(80) NOT NULL default '',
  `views` mediumint(8) unsigned NOT NULL default '0',
  `level` tinyint(1) unsigned NOT NULL default '0',
  `level_time` int(10) unsigned NOT NULL default '0',
  `source` varchar(255) NOT NULL default '',
  `comments` mediumint(8) unsigned NOT NULL default '0',
  `timestamp` int(10) unsigned NOT NULL default '0',
  `verify_frame` varchar(255) NOT NULL default '',
  `create_time` int(10) unsigned NOT NULL default '0',
  `update_time` int(10) unsigned NOT NULL default '0',
  `list_order` int(10) unsigned NOT NULL default '0',
  `verified` tinyint(1) NOT NULL default '0',
  `verifier` tinyint(1) NOT NULL default '0',
  `ever_verified` tinyint(1) NOT NULL default '0',
  `allow_comment` tinyint(1) unsigned NOT NULL default '1',
  `allow_mood` tinyint(1) unsigned NOT NULL default '1',
  `credit` tinyint(3) unsigned NOT NULL default '0',
  `credit_type` smallint(5) unsigned NOT NULL default '0',
  `digg` mediumint(8) NOT NULL default '0',
  `trample` mediumint(8) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `cid` (`cid`,`list_order`),
  KEY `cid_id` (`cid`,`id`),
  KEY `level` (`level`,`list_order`),
  KEY `site_cid_id` (`site`,`cid`,`id`),
  KEY `timestamp` (`timestamp`),
  KEY `uid` (`uid`)
)ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE `p8_item_unverified` (
  `id` int(10) unsigned NOT NULL,
  `model` varchar(20) NOT NULL default '',
  `title` varchar(100) NOT NULL default '',
  `site` varchar(50) NOT NULL DEFAULT '',
  `cid` mediumint(8) unsigned NOT NULL default '0',
  `uid` mediumint(8) unsigned NOT NULL default '0',
  `username` varchar(20) NOT NULL default '',
  `attributes` varchar(40) NOT NULL default '',
  `pages` smallint(5) unsigned NOT NULL default '1',
  `views` mediumint(8) unsigned NOT NULL default '0',
  `level` tinyint(1) unsigned NOT NULL default '0',
  `level_time` int(10) unsigned NOT NULL default '0',
  `source` varchar(255) NOT NULL default '',
  `comments` mediumint(8) unsigned NOT NULL default '0',
  `timestamp` int(10) unsigned NOT NULL,
  `verified` tinyint(1) NOT NULL default '0',
  `ever_verified` tinyint(1) NOT NULL default '0',
  `data` longtext NOT NULL,
  `push_back_reason` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY  (`uid`, `timestamp`),
  KEY `site_cid_id` (`site`,`cid`,`id`),
  KEY `cid` (`cid`,`timestamp`)
)ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE `p8_category` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `parent` smallint(5) unsigned NOT NULL,
  `matrix` smallint(5) unsigned NOT NULL,
  `name` varchar(60) NOT NULL DEFAULT '',
  `site` varchar(50) NOT NULL DEFAULT '',
  `letter` varchar(2) NOT NULL DEFAULT '',
  `model` varchar(20) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  `domain` varchar(255) NOT NULL DEFAULT '',
  `frame` varchar(255) NOT NULL DEFAULT '',
  `type` tinyint(1) unsigned NOT NULL,
  `item_count` mediumint(8) unsigned NOT NULL,
  `htmlize` tinyint(1) unsigned NOT NULL,
  `html_list_url_rule` varchar(255) NOT NULL DEFAULT '',
  `html_view_url_rule` varchar(255) NOT NULL DEFAULT '',
  `path` varchar(255) NOT NULL DEFAULT '',
  `page_size` smallint(5) unsigned NOT NULL DEFAULT '20',
  `list_template` varchar(50) NOT NULL DEFAULT '',
  `list_template_mobile`  varchar(50) NOT NULL DEFAULT '',
  `view_template` varchar(50) NOT NULL DEFAULT '',
  `view_template_mobile`  varchar(50) NOT NULL DEFAULT '',
  `item_template` varchar(50) NOT NULL DEFAULT '',
  `item_template_mobile`  varchar(50) NOT NULL DEFAULT '',
  `display_order` smallint(5) unsigned NOT NULL DEFAULT '0',
  `seo_keywords` text NOT NULL,
  `seo_description` text NOT NULL,
  `label_postfix` varchar(50) NOT NULL DEFAULT '',
  `list_all_model`  tinyint(1) NOT NULL DEFAULT 0,
  `config` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `model` (`model`),
  KEY `site` (`site`)
)ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE `p8_category_recycle` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `parent` smallint(5) unsigned NOT NULL,
  `matrix` smallint(5) unsigned NOT NULL,
  `name` varchar(60) NOT NULL DEFAULT '',
  `site` varchar(50) NOT NULL DEFAULT '',
  `letter` varchar(2) NOT NULL DEFAULT '',
  `model` varchar(20) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  `domain` varchar(255) NOT NULL DEFAULT '',
  `frame` varchar(255) NOT NULL DEFAULT '',
  `type` tinyint(1) unsigned NOT NULL,
  `item_count` mediumint(8) unsigned NOT NULL,
  `htmlize` tinyint(1) unsigned NOT NULL,
  `html_list_url_rule` varchar(255) NOT NULL DEFAULT '',
  `html_view_url_rule` varchar(255) NOT NULL DEFAULT '',
  `path` varchar(255) NOT NULL DEFAULT '',
  `page_size` smallint(5) unsigned NOT NULL DEFAULT '20',
  `list_template` varchar(50) NOT NULL DEFAULT '',
  `list_template_mobile`  varchar(50) NOT NULL DEFAULT '',
  `view_template` varchar(50) NOT NULL DEFAULT '',
  `view_template_mobile`  varchar(50) NOT NULL DEFAULT '',
  `item_template` varchar(50) NOT NULL DEFAULT '',
  `item_template_mobile`  varchar(50) NOT NULL DEFAULT '',
  `display_order` smallint(5) unsigned NOT NULL DEFAULT '0',
  `seo_keywords` text NOT NULL,
  `seo_description` text NOT NULL,
  `label_postfix` varchar(50) NOT NULL DEFAULT '',
  `list_all_model`  tinyint(1) NOT NULL DEFAULT 0,
  `config` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `model` (`model`),
  KEY `site` (`site`)
)ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE `p8_menu` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `site` char(50) NOT NULL default '',
  `action` char(50) NOT NULL default '',
  `parent` mediumint(8) unsigned NOT NULL default '0',
  `color` char(7) NOT NULL default '',
  `name` char(30) NOT NULL default '',
  `url` char(255) NOT NULL default '',
  `dynamic_url` char(255) NOT NULL default '',
  `target` char(10) NOT NULL default '',
  `display` tinyint(1) unsigned NOT NULL default '1',
  `front` tinyint(1) NOT NULL default '0',
  `display_order` mediumint(8) unsigned NOT NULL default '0',
  `summary` text NOT NULL,
  `frame` CHAR( 255 ) NOT NULL,
  PRIMARY KEY  (`id`)
)ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE `p8_log` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `site` char(50) NOT NULL default '',
  `username` char(30) NOT NULL default '',
  `title` varchar(255) NOT NULL default '',
  `url` varchar(255) NOT NULL default '',
  `request` text NOT NULL default '',
  `ip` char(15) NOT NULL default '',
  `timestamp` int(10) NOT NULL,
  PRIMARY KEY  (`id`)
)ENGINE=MyISAM  DEFAULT CHARSET=utf8;