<?php
defined('PHP168_PATH') or die();

/**
* 内容管理
**/

$this_system->check_manager($ACTION) or message('no_privilege');

$allsites  = $this_system->get_sites();

$sphinx = $this_module->CONFIG['sphinx'];
$use_sphinx = false;

if(!empty($_REQUEST['model'])){
	$this_system->init_model();
	$sphinx['index'] = $this_system->sphinx_indexes(array($MODEL => 1));
	
	$this_model or message('no_such_sites_model');
}else{
	$MODEL = '';
	$sphinx['index'] = $this_system->sphinx_indexes();
}

//加载分类模块
$category = &$this_system->load_module('category');
$cid = isset($_GET['cid']) ? intval($_GET['cid']) : 0;
$this_site_name = $this_system->SITE;
$minquery = $core->DB_master->fetch_one("SELECT `create_time` FROM $this_system->item_table where `site` = '$this_site_name' and `create_time` !=0 order by `create_time` asc limit 0,1");
$maxquery = $core->DB_master->fetch_one("SELECT `create_time` FROM $this_system->item_table where `site` = '$this_site_name' and `create_time` !=0 order by `create_time` desc limit 0,1");
$first_year = date('Y',$minquery['create_time']);
$this_year = date('Y',$maxquery['create_time']);
$this_mon = intval(date('m',$maxquery['create_time']));
$mon = isset($_GET['mon']) ? intval($_GET['mon']) : $this_mon>=2 ? $this_mon-1 : 12;
$mindate = isset($_GET['mindate']) ? $_GET['mindate'] : date('Y-m-d',$minquery['create_time']);
$maxdate = isset($_GET['maxdate']) ? $_GET['maxdate'] : date('Y-m-d',$maxquery['create_time']);
$compare_type = isset($_GET['compare_type']) ? $_GET['compare_type'] : '';
$compare_type_name = array(
	'post_year'=> '年度预警值',
	'post_quarter'=> '季度预警值',
	'post_month'=> '月度预警值',
	'post_week'=> '星期预警值',
	
);
$category->get_cache();

if(!P8_AJAX_REQUEST){
	
	
	//所有模型
	$models = $this_system->get_models();
	//模型JSON
	$model_json = p8_json($models);
	//分类JSON
	$category_json = $category->get_json();
	//属性JSON
	
    
	include template($this_module, 'report', 'admin');
	exit;
}

$select = select();
$select->in('site', $this_system->SITE);
$select->from($this_module->main_table,'cid,count(*) count');


if($mindate){
	$select -> range('timestamp',strtotime($mindate));
}	
if($maxdate){
	$select -> range('timestamp',null,strtotime($maxdate));
}

if($MODEL){
	$select->in('model', $MODEL);
}
$category->get_cache();
if($cid){
	$ids = array($cid) + $category->get_children_ids($cid);	
	$select->in('cid', $ids);
}
$select->group('cid');
$select->order('count desc');
//取数据
$count = 0;
$list = $core->list_item(
	$select,
	array(
		'count' => 100,
		'ms' => 'master',			
	)
);
//echo $select->build_sql();

/*标准量*/
$category_list = array();
foreach($category->categories as $cat_item){	
	$category_list[$cat_item['id']] = array(
		'id' => $cat_item['id'],
		'name' => $cat_item['name'],
		'post_year'=> isset($cat_item['post_year']) && !empty($cat_item['post_year']) ? intval($cat_item['post_year']) : 0,
		'post_quarter'=> isset($cat_item['post_quarter']) && !empty($cat_item['post_quarter']) ? intval($cat_item['post_quarter']) : 0,
		'post_month'=> isset($cat_item['post_month']) && !empty($cat_item['post_month']) ? intval($cat_item['post_month']) : 0,
		'post_week'=> isset($cat_item['post_week']) && !empty($cat_item['post_week']) ? intval($cat_item['post_week']) : 0,
	);		
}

/*取数据*/
$category_title = $category_data = array();
$post_year = $post_quarter = $post_month = $post_week = array();
foreach($list as $item){
	$category_title[] = $category_list[$item['cid']]['name'];
	$category_data[] = $item['count'] ? intval($item['count']) : 0;
	$post_year[] = isset($category_list[$item['cid']]['post_year']) ? intval($category_list[$item['cid']]['post_year']) : 0;
	$post_quarter[] = isset($category_list[$item['cid']]['post_quarter']) ? intval($category_list[$item['cid']]['post_quarter']) : 0;
	$post_month[] = isset($category_list[$item['cid']]['post_month']) ? intval($category_list[$item['cid']]['post_month']) : 0;
	$post_week[] = isset($category_list[$item['cid']]['post_week']) ? intval($category_list[$item['cid']]['post_week']) : 0;
}

$category_post = array(
	'compare_type' => $compare_type,
	'compare_type_name' => !empty($compare_type) ? $compare_type_name[$compare_type] : '',
	'compare_data' => !empty($compare_type) ? $$compare_type : array(),
	'category_title' => $category_title,
	'category_data' => $category_data,
);

echo p8_json($category_post);
